/**
 * @file  grlft_font.h
 *
 * @version  $Id: grlft_font.h,v 1.44.12.1.4.3 2012/09/04 16:43:14 harsha.mm Exp $
 *
 * This header file declares the functions and types that are provided by the GRLFT font module
 * <detailed description>
 * @component SVGFont
 *
 * @author      D.Langner  / ADIT-G / SWG / dlangner@de.adit-jv.com
 *              C.Spetzler / ADIT-G / SWG / cpspetzler@de.adit-jv.com
 *
 * @copyright   (c) 2003 - 2006 ADIT Corporation
 *
 * @see <related items>
 *
 *
 ******************************************************************************/
#ifndef GRLFT_FONT_H
#define GRLFT_FONT_H

#include "grl_font.h"
#include "svg_font.h"
#include "ft2build.h"
#include <freetype2/config/ftheader.h>
#include FT_STROKER_H
#include FT_MODULE_H
//#include FT_INTERNAL_OBJECTS_H
#include "svg_typedef.h"
#include "EGL/egl.h"
#include "grl_os_abstraction.h"

#include "util_hash.h"

#ifdef HAS_OPENVG
#include "VG/openvg.h"
#endif

#ifdef HAS_OPENGLES1
#include "GLES/gl.h"
#define HAS_OPENGLES 1
#endif

#ifdef HAS_OPENGLES2
#include "GLES2/gl2.h"
#define HAS_OPENGLES 1
#endif

#include FT_FREETYPE_H

#define NO_STYLE_STRING "Regular"
#define NO_STYLE_SIZE   7

#define FILLED_PIXEL_RATIO 0.8f
#define MORE_CHARS_THEN_NEEDED 6


typedef enum {
    SVG_DRAWING_API_MIN,
    SVG_USE_OPENVG,
    SVG_USE_OPENGLES_1,
    SVG_USE_OPENGLES_2,
    SVG_DRAWING_API_MAX
} SVGDrawingAPI;

typedef struct texture_col{
    SVGFloat            x;
    SVGFloat            free_width;
    struct texture_col* next;
}textureCol;

typedef struct texture_row{
    SVGFloat            y;
    SVGFloat            height;
    SVGBoolean          fixed;
    textureCol*         col;
    struct texture_row* next;
    struct texture_row* prev;
}textureRow;


typedef struct internal_cache_struct{
    SVGUint32  glyph;
    SVGUint32  index;    /*don't change the order of first 3 members*/
    SVGUint32  font_size;/*it will affect hash-cashing*/
    SVGFloat   top;
    SVGFloat   left;
    SVGFloat   advance;
    SVGFloat   top_hor;
    SVGFloat   top_ver;
    SVGFloat   left_hor;
    SVGFloat   left_ver;
    SVGFloat   width;
    SVGFloat   height;
    SVGFloat   advance_hor;
    SVGFloat   advance_ver;
    SVGFloat   lsb_delta;
    SVGFloat   rsb_delta;
    SVGFloat   source_x;
    SVGFloat   source_y;
#ifdef HAS_OPENVG
    VGImage    VGimage; 
#endif
    SVGFloat   texture_width;
    SVGFloat   texture_height;
    SVGFloat   texture_source_x;
    SVGFloat   texture_source_y;
    FT_Glyph   ft_glyph;
    SVGBoolean cached_bitmap;
    SVGBoolean glyph_done;
    struct internal_cache_struct*   next;
    struct internal_cache_struct*   prev;
	SVGBoolean is_in_use;
	
	SVGFloat horz_bearingx;
	SVGFloat horz_bearingy;
	SVGFloat vert_bearingx;
	SVGFloat vert_bearingy;
	SVGFloat metrics_width;
	SVGFloat metrics_height;
	SVGFloat metrics_advance_x;
	SVGFloat metrics_advance_y;
} grl_internal_cache_struct;

typedef struct grl_late_draw_struct_
{
    grl_internal_cache_struct* cache_current;
    SVGFloat                   offset_x;
    SVGFloat                   offset_y;
}grl_late_draw_struct;


typedef struct get_char_info_struct_
{
    SVGUint8*       theChar;                 /* current character             */
    SVGUint32       decodedChar;             /* character value after decoding */
    SVGUint32       theGlyph;                /* current freetype glyph        */
    SVGUint32       prevGlyph;               /* the previous freetype glyph   */
    SVGUint32       index;
    SVGUint32       flags;
    SVGPoint        next_pos;
    SVGEncoding     encoding;
    SVGFloat        lsb_delta;
    SVGFloat        rsb_delta;
    SVGFloat        prev_rsb_delta;
    SVGFloat        angle;
    SVGUint32       *CharIndexList;	/* contains glyph index list */
    SVGUint32       textlength;
} get_char_info_struct;


typedef struct bbox_struct_
{
    SVGFloat                 top;           
    SVGFloat                 left;
    SVGFloat                 width;          /* the width of bbox             */
    SVGFloat                 height;         /* the height of bbox            */
} bbox_struct;

extern grl_fontmodule_fp grl_ft;


typedef struct
{
	FT_Library                library;       /* handle to library             */ //->share
    FT_Face                   face;          /* handle to face object         */ //->share
    FT_Stroker                stroker;       /* freetype stroker for outlines */ //->share
	SVGUint32                 mem_guard1;
    UTIL_hash_table_t         *hash_tbl_strk; /* hash table for stroked glyphs*/
    grl_internal_cache_struct *cache_strk;
    SVGUint32                 cache_count_strk;

    UTIL_hash_table_t         *hash_tbl_fill; /* hash table for filled glyphs*/	
    grl_internal_cache_struct *cache_fill;
    SVGUint32                 cache_count_fill;

	SVGUint32				  *cache_count;
	UTIL_hash_table_t         *hash_tbl_glyphs;
	grl_internal_cache_struct **cache;
    grl_internal_cache_struct *cache_current; /* current points to fill_current or to stroke_current */
    SVGUint32                 late_glyphs_size;
    grl_late_draw_struct      *late_glyphs;           /* holds "glyph information" for OpenGL and No_EnclosingSpaces */
    GRL_lock_id               id;
    SVGFont                   *p_svgFont;             /* Pointer to SVGFont            */
#ifdef HAS_OPENVG
    textureRow*               vgRowStrk;
    textureRow*               vgRowFill;
    VGImage                   vgWallpaperStrk;          /* the wallpaper for storing all stoked glyphs for OpenVG */
    VGImage                   vgWallpaperFill;          /* the wallpaper for storing all filled glyphs for OpenVG */
    SVGUint32                 vgWallpaperWidth;
    SVGUint32                 vgWallpaperHeight;
#endif
#ifdef HAS_OPENGLES
    textureRow*               glRowStrk;
    textureRow*               glRowFill;
    GLuint                    glWallpaperStrk;          /* the wallpaper for storing all stroked glyphs for OpenGL */
    GLuint                    glWallpaperFill;          /* the wallpaper for storing all filled glyphs for OpenGL */
    SVGUint32                 glWallpaperWidth;
    SVGUint32                 glWallpaperHeight;
#endif    
    SVGUint32                 mem_guard2;
#ifdef HAS_OPENGLES2
    SVGUint32                 programHandle;
    SVGUint32                 shaderHandle[2];
    SVGInt32                  noaalocation;
    SVGInt32                  opacitylocation;
    SVGInt32                  colorlocation;
    SVGInt32                  mvplocation;
    SVGUint32                 texturelocation;
    SVGUint32                 vertexlocation;
    SVGFloat                  modelview[4][4];
    SVGFloat                  mvp[4][4];
#endif
	void					  *p_shape_eng;
}SVGFontShared;



/**
 *  @struct Structure definition of function pointer table of shaping engien plugin modules.
 */
typedef struct _grl_shapeEng_module_fp{
/* all functions */
SVGError (*CreateFont)     ( void *p_shapeeng,FT_Face face );
SVGError (*DeleteFont)     ( void *p_shapeeng );
SVGError (*glyphshaping)   ( void *p_shapeeng,get_char_info_struct* pchar_info,
      						void *cachedctx,SVGUint32 encoding);
SVGUint32 (*GetGlyphCount) ( void *p_shapeeng );
SVGUint32 (*GetGlyphCharIndex)( void *p_shapeeng,SVGUint32 glyphindex );
void (*GetGlyphOffsets)( void *p_shapeeng,SVGUint32 glyphindex,
 								SVGInt32 *Xoffset,SVGInt32 *Yoffset );
SVGUint32 (*SetLangscript_rendrdirection) ( void *p_shapeeng,SVGUint32 In_langscript,
                                                            SVGUint32 In_Rendrdirection);
void (*DestroyBuffObjects)( void *p_shapeeng );
}grl_shapeEng_module_fp;


/**
 *  @struct Structure definition for Freetype Font Renderer Structures
 */
typedef struct {
    SVGDrawingAPI             drawingAPI;    /* which API is used */
#ifdef HAS_OPENVG
    VGPaint                   VGpaint;       /* the OpenVG paint handle       */
#endif    
#ifdef HAS_OPENGLES
    GLint                     screen_width;
    GLint                     screen_height;
    SVGInt32                  gl_mode;
    SVGInt32                  glUnpackAlignment;
#endif
    SVGFloat                  ascender;     /* calculated ascender value */     //->share
    SVGFloat                  descender;    /* calculated descender value */    //->share
    SVGFloat                  left;         /* calculated bbox_x_min */
    SVGFloat                  right;        /* calculated bbox_y_min */
    SVGFloat                  origin_hor;   /* origin of the font for horizontal alignment*/
    SVGFloat                  origin_ver;   /* origin of the font for vertical alignment*/
    SVGFloat                  left_offset;  /* hor offset for no_enclosing_spaces */
    SVGFloat                  top_offset;   /* ver offset for no_enclosing_spaces */
    SVGFloat                  underline_position;
    SVGFloat                  underline_thickness;
    SVGUint32                 font_size;
    SVGUint32                 replacementGlyph;
    SVGBoolean                useReplacementGlyph;
    SVGFloat                  additional_space;
    SVGFloat                  kerning;
    SVGFloat                  sin_angle;
    SVGFloat                  cos_angle;
    SVGUint32                 index;
    SVGFloat                  top_most;
    SVGFloat                  bottom_most;
    SVGFloat                  left_most;
    SVGFloat                  right_most;
    SVGUint32                 stroke_width;
    SVGFloat                  stroke_color[4];
    SVGFloat                  fill_color[4];
    SVGBoolean                is_vertical;
    SVGFloat                  advance_x;
    SVGFloat                  advance_y;
    SVGUint32                 kern_mode;
    SVGFontShared*            shared;
    textureRow*               row;
    SVGUint32                 wallpaperWidth;
    SVGUint32                 wallpaperHeight;
    SVGUint32                 start;    /* 0->stroke;      1->no stroke */
    SVGUint32                 end;      /* 1->no fill; 2->fill */
    /* combinations: 0/1 fill only; 0/2 2color; 1/2 outline */
    SVGFloat                  offset_x;
    SVGFloat                  offset_y;
    SVGFloat                  scale_x;            /* Size scaling factor for x     */
    SVGFloat                  scale_y;            /* Size scaling factor for y     */
    SVGUint32                 texture;
    SVGBoolean                is_first_char;
    SVGFloat                  extra_ver;
    SVGBoolean                stroker_availabe;
    SVGFloat                  distance_x;
    SVGFloat                  distance_y;
	SVGUint32                 cachable_glyphs;
    SVGUint32                 max_texture_size;
	/* Pointer to the function pointer table of shape engine plugin */
	grl_shapeEng_module_fp    *p_grl_shpeng_fp_table;
    void                      *p_shapeeng;
    SVGUint32                 cached_rendrflags;/* used in glyph caching*/
    SVGUint32                 cached_index;/* used in glyph caching*/
    SVGUint32                 max_font_size; /* To calculate maximum fontSize possible, based on max texture size supported */
    SVGLangScript          script_tag;
    SVGBoolean                enableshapingeng; /* To enable the harfbuzz shaping engine in order to support complex script*/
    SVGBoolean                autolangdetect;
}SVGFontFreeTypeRenderer;


extern void	           grlft_get_font_suffix( S8 **suffix_list, U32 *list_size);

extern void            grlft_fill_font_struct( SVGUint32 *font_filenames, SVGUint32 num_files, SVGFont **fonts, SVGUint32 *max_fonts);

extern void            grlft_init_font_plugin( SVGFontModule* module );

extern void            grlft_close_font_plugin( void );

extern SVGError        grlftGetFontError( SVGFontContext *ctx );

extern SVGFontContext* grlftCreateFontContext(EGLContext ctx, SVGFontContext* shareContext);

extern SVGBoolean      grlftDestroyFontContext( SVGFontContext* ctx);

extern void            grlftDisableFontSettings( SVGFontContext* ctx,
                                                 SVGUint32 settings);

extern void            grlftDrawFontWithCursorInfo( SVGFontContext* ctx,
                                                    SVGFloat positionX,
                                                    SVGFloat positionY,
                                                    SVGUint8* text,
                                                    SVGUint32 textLength,
                                                    SVGPoint* cursorPosArray );


extern void            grlftEnableFontSettings( SVGFontContext* ctx,
                                                SVGUint32 settings);

extern void            grlftFreeFontBitmapMem( SVGFontContext* ctx,
                                               SVGUint32 texture);

extern void            grlftGetFontBitmap( SVGFontContext* ctx,
                                           SVGUint8* text,
                                           SVGUint32 textLength,
                                           SVGUint32* texture,
                                           SVGFloat* width,
                                           SVGFloat* height);

extern SVGUint32       grlftGetFontBitmapExt( SVGFontContext* ctx,
                                              SVGUint8**      text,
                                              SVGUint32*      textLength,
                                              SVGUint32	   	  textNumber,
                                              SVGUint32*      filledTexture,
											  SVGUint32*      strokedTexture,											
                                              SVGBBox**       filledTextureBox,
                                              SVGBBox**       strokedTextureBox,
                                              SVGBBox**       filledGlyphBox,
                                              SVGBBox**       strokedGlyphBox,
                                              SVGUint32*      glyphNumber);

extern void 			grlftDumpFontWallpaper( SVGFontContext* ctx, 
											    SVGUint32 		settings, 
												SVGInt8			*fileName);
											  
extern SVGBoolean      grlftIsFontSettingEnabled( SVGFontContext* ctx,
                                                  SVGUint32 setting);

extern void            grlftLoadFont( SVGFontContext* ctx,
                                      SVGFont* font,
                                      SVGEncoding charMap,
                                      SVGUint32 fontSize);

extern void            grlftSetFontSize( SVGFontContext* ctx,
                                         SVGUint32 fontSize);

extern void            grlftGetFontBBox( SVGFontContext* ctx,
                                          SVGUint8* text,
                                          SVGUint32 textLength,
                                          SVGBBox* textBBox);

extern SVGUint32       grlftGetFontMaxChars( SVGFontContext* ctx,
                                             SVGFloat max_space_x,
                                             SVGFloat max_space_y,
                                             SVGUint8* text,
                                             SVGUint32 textLength);

extern void            grlftGetFontInformation ( SVGFontContext *ctx,
                                                 SVGFontInfo *info );

extern void            grlftSetError( SVGFontContext* ctx,
                                      SVGError error);

extern void            grlftDrawFontStringExt( SVGFontContext* ctx,
                                               SVGPoint* position,
                                               SVGFloat* angle,
                                               SVGUint8* glyphs,
                                               SVGUint32 glyphLength);

extern void            grlftSetCachableGlyphCount(SVGFontContext *ctx,
							                      SVGUint32      glyph_count,
							                      SVGFontInfo    *info);

extern grl_shapeEng_module_fp*	grl_GetShapeng_fptable( void );

extern  SVGError 		grl_initShapeEng_Plugin(  void **p_shapeeng,
											   SVGUint32 langscript,
											   SVGUint32 rendr_direction );

extern void 		   grl_ShapeEng_Plugout( void *p_shapeeng );

extern SVGError 	   grlft_get_glyphmetrics(  SVGFontContext* p_ctx,
												SVGUint32	*theglyph );


extern SVGError 	   grlft_get_stringunicodelist( void *ctx,
											   get_char_info_struct* char_info,
											   SVGUint32		textlength );

extern SVGBoolean grlftEnableShapingEng(SVGLangScript langscript,
                                     SVGBoolean    autolang_detect_enable);

extern SVGBoolean grlftDisableShapingEng(SVGLangScript langscript,
                                  SVGBoolean    autolang_detect_disable);


extern void grlftReadShpEngConfig(void);
#endif	/* GRLFT_FONT_H */

